IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Localidades_Cliente') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Localidades_Cliente
END
GO

CREATE PROCEDURE [dbo].[CPJ_Localidades_Cliente]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

--MODIFICACIONES:
--01/02/2022 10:40Hs Se agrega validacion con parametro cant_min_reserva

/*Variables recibidas por paremetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Cliente			INT
DECLARE @pId_Lista_Precio		INT
DECLARE @pId_Sector				INT
DECLARE @pFlag_Interface		CHAR(1)

SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Cliente		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Lista_Precio	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio')), 0)
SET @pId_Sector			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Sector')), 0)
SET @pFlag_Interface	= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Flag_Interface')), '')	--'G': Grafica Estadio Futbol | '' o 'E': Entradas adquiridas/renovables
/*FIN Variables recibidas por parametro a traves del JSON*/
--EXEC CPJ_Localidades_Cliente '{"ModoDebug":"1","Id_Cliente":"0","Id_Lista_Precio":"2001","Id_Sector":"6","Flag_Interface":"G"}'


/*Variables Locales*/
DECLARE @SqlStr					NVARCHAR(MAX)
DECLARE @SqlStrs				NVARCHAR(MAX)
DECLARE @Id_Cliente_Ref			INT
DECLARE @Cant_Minutos_Reserva	INT
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Localidades_Cliente'
		PRINT 'Parametros: '+ @pJson  
	END

	/*====================================================================================================================================================*/
	
	SET @Cant_Minutos_Reserva = (SELECT dbo.CF_xParam('cant_min_reserva'))

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Cant_Minutos_Reserva: '+ CONVERT(VARCHAR(10), @Cant_Minutos_Reserva)  
	END

	/*====================================================================================================================================================*/

	IF(@pId_Cliente > 0)
	BEGIN
		SELECT
		@Id_Cliente_Ref = ISNULL(Id_Cliente_Ref, 0)
		FROM Clientes 
		WHERE
		Id_Cliente = @pId_Cliente

		IF(@Id_Cliente_Ref = 0)
		BEGIN
			SET @Id_Cliente_Ref = @pId_Cliente
		END
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Id_Cliente_Ref: '+ CONVERT(VARCHAR(10), @Id_Cliente_Ref)  
	END

	/*====================================================================================================================================================*/

	IF OBJECT_ID('tempdb..#Rta_CPJ_Localidades_Cliente') IS NOT NULL
	BEGIN
		DROP TABLE #Rta_CPJ_Localidades_Cliente
	END

	CREATE TABLE #Rta_CPJ_Localidades_Cliente (Id_Trans				INT
											, Id_Cliente			INT
											, Id_Lista				INT
											, Razon_Social			VARCHAR(100)
											, Fecha_QA				DATETIME
											, Fecha_Venc			DATETIME
											, Fecha_Desde			DATETIME
											, Fecha_Hasta			DATETIME
											, Descripcion			VARCHAR(100)
											, Id_Producto			VARCHAR(14)
											, Descripcion_Resumida	VARCHAR(100)
											, Estado				VARCHAR(10)
											, Serie					VARCHAR(100))

	/*====================================================================================================================================================*/

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Localidades_Cliente '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	' CASE 
						WHEN	CONVERT(DATE, ISNULL(CI.Fecha_QA, ''19000101'')) <= CONVERT(DATE, GETDATE()) 
								AND (CONVERT(DATE, ISNULL(CI.Fecha_Venc, ''19000101'')) >= CONVERT(DATE, GETDATE()) OR CI.Fecha_Venc IS NULL) 
								THEN ''C''
						WHEN	ISNULL(PLP.Evento_Cant_Dias_Renov_Prev, 0) > 0 
								AND CONVERT(DATE, ISNULL(CI.Fecha_QA, ''19000101'')) <= CONVERT(DATE, GETDATE()) 
								AND CI.Fecha_Venc IS NOT NULL
								AND CONVERT(DATE, ISNULL(CI.Fecha_Venc, ''19000101'')) >= CONVERT(DATE, GETDATE())
								AND DATEADD(DAY, (-1) *  ISNULL(PLP.Evento_Cant_Dias_Renov_Prev, 0),  ISNULL(CI.Fecha_Venc, ''19000101'')) <= CONVERT(DATE, GETDATE()) 
								THEN ''CR''
						WHEN	ISNULL(PLP.Evento_Cant_Dias_Limite, 0) > 0
								AND CONVERT(DATE, ISNULL(CI.Fecha_QA, ''19000101'')) <= CONVERT(DATE, GETDATE())
								AND CI.Fecha_Venc IS NOT NULL
								AND DATEADD(DAY, ISNULL(PLP.Evento_Cant_Dias_Limite, 0), CONVERT(DATE, CI.Fecha_Venc)) >= CONVERT(DATE, GETDATE())
								THEN ''R''
						WHEN	(ISNULL(PR.Fecha_Reserva, ''19900101'') >= DATEADD(MINUTE,- ' + CONVERT(VARCHAR(5), @Cant_Minutos_Reserva) +  ',GETDATE()))
								THEN ''RP''
						ELSE ''V''
					END Estado,
					CI.Serie'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND ISNULL(CI.Id_Producto, '''') = PR.Id_Producto'
	SET @SqlStr +=	' AND ISNULL(CI.Id_Cliente, 0) = CL.Id_Cliente'
	SET @SqlStr +=	' AND ISNULL(CB.Id_Lista, 0) = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND ISNULL(CB.Id_Tipo_Cbte, '''') = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND (ISNULL(CT.Compromete_Factura, 0) = 1 OR ISNULL(Compromete_Remitos, 0) = 1)'
	SET @SqlStr +=	' AND ISNULL(CB.Id_Estado_Cbte, 0) NOT IN (0,3,1)'
	
	IF(@pFlag_Interface IN ('', 'E'))
	BEGIN
		SET @SqlStr +=	' AND ISNULL(PLP.Flag_Localidades, 0) = 1'
	END

	IF(@pFlag_Interface = 'G')
	BEGIN
		SET @SqlStr +=	' AND ISNULL(PLP.Flag_Localidades, 0) IN (1,2)'
	END

	SET @SqlStr +=	' AND ISNULL(PR.Tipo, '''') = ''L'''
	SET @SqlStr +=	' AND ISNULL(CI.Flag_QA, '''') = ''A'''

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR ISNULL(CL.Id_Cliente_Ref, 0) = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END
	/*
	IF(@pId_Lista_Precio <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = ' + CONVERT(VARCHAR(10), @pId_Lista_Precio) 
	END*/
			
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND ISNULL(PR.Id_Sector, 0) = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	/*====================================================================================================================================================*/

	EXECUTE sp_executesql @SqlStr

	/*====================================================================================================================================================*/

	/*17/02/2022 Protocolos Ubicables*/
	
	SET @SqlStr =	'INSERT INTO #Rta_CPJ_Localidades_Cliente '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' 0 AS Id_Trans,'
	SET @SqlStr +=	' 0 AS Id_Cliente,'
	SET @SqlStr +=	' 0 AS Id_Lista,'
	SET @SqlStr +=	' '''' AS Razon_Social,'
	SET @SqlStr +=	' '''' AS Fecha_QA,'
	SET @SqlStr +=	' '''' AS Fecha_Venc,'
	SET @SqlStr +=	' '''' AS Fecha_Desde,'
	SET @SqlStr +=	' '''' AS Fecha_Hasta,'
	SET @SqlStr +=	' '''' AS Descripcion,'
	SET @SqlStr +=	' I.Id_Producto AS Id_Producto,'
	SET @SqlStr +=	' '''' AS Descripcion_Resumida,'
	SET @SqlStr +=	' ''C'' AS Estado,'
	SET @SqlStr +=	' '''' AS Serie'
	SET @SqlStr +=	' FROM Tab_Ent_Protocolares_Items I, Tab_Ent_Protocolares E, Productos PR'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' I.Id_Ent_Protocolo = E.Id_Ent_Protocolo'
	SET @SqlStr +=	' AND I.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND I.Activo = 1'
	SET @SqlStr +=	' AND E.Activo = 1'

	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr
	
	/*FIN 17/02/2022 Protocolos Ubicables*/

	/*====================================================================================================================================================*/


	IF(@pFlag_Interface IN ('', 'E'))
	BEGIN
		SELECT * FROM #Rta_CPJ_Localidades_Cliente
	END

	IF(@pFlag_Interface = 'G')
	BEGIN
		SELECT * FROM #Rta_CPJ_Localidades_Cliente WHERE Estado <> 'V'
	END

	/*====================================================================================================================================================*/

	IF OBJECT_ID('tempdb..#Rta_CPJ_Localidades_Cliente') IS NOT NULL
	BEGIN
		DROP TABLE #Rta_CPJ_Localidades_Cliente
	END

	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Localidades_Cliente'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 


-- EXEC CPJ_Localidades_Cliente '{"ModoDebug":"1","Id_Cliente":0}'
